/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class Benutzerschnittstelle
extends JFrame {
    private static final Color FELD_VERAENDERBAR = Color.green;
    private static final Color FELD_NICHT_VERAENDERBAR = Color.black;
    private static final Color FELD_STANDART_HINTERGRUND = Color.white;
    private static final Color FELD_VERAENDERT_HINTERGRUND = Color.lightGray;
    private static final Color FELD_AKTUELLES_FELD = Color.yellow;
    private static final Color PRUEFEN_BUTTON_RICHTIG = Color.green;
    private static final Color PRUEFEN_BUTTON_FALSCH = Color.red;
    private Color aktuelleHintergrundfarbe;
    private Steuerung steuerung;
    private JButton pruefen;
    private HashMap<JButton, Integer> hashMapButtonBenutzereingabe;
    private JButton[][] spielfeldMitAllenKnoepfen;
    private HashSet<JButton> benutzereingabe;
    private JMenuBar menuBar;

    public Benutzerschnittstelle(Steuerung pSteuerung) {
        this.steuerung = pSteuerung;
        this.erstelleBildschirm();
    }

    private void ladeSudokuBefehl(int pNummer) {
        this.steuerung.ladeSudoku(new Integer(pNummer));
        this.refresh();
    }

    private void hellerBefehl() {
        this.aktuelleHintergrundfarbe = FELD_STANDART_HINTERGRUND;
        this.felderAktualisieren();
    }

    private void dunklerBefehl() {
        this.aktuelleHintergrundfarbe = FELD_VERAENDERT_HINTERGRUND;
        this.felderAktualisieren();
    }

    private void zeigeVersionBefehl() {
        JOptionPane.showMessageDialog(null, "Sudoku\n" + this.steuerung.gibVersion(), "Info zu Sudoku", 1);
    }

    private void zeigeAnleitungBefehl() {
        JOptionPane.showMessageDialog(null, "Spielanleitung: Waehl dir links ein Sudoku.\n Dann kannst du ein Feld mit der Maus auswaehlen und eine Zahl eingeben.\n Mit pruefen kannst du sehen, ob du richtig bist. gruen = richtig. rot = falsch", "", 1);
    }

    private void beendenBefehl() {
        System.exit(0);
    }

    private void pruefenBefehl() {
        if (this.steuerung.istSudokuInitialisiert()) {
            boolean tmp = this.steuerung.testeObSudokuKorrektIst();
            if (tmp) {
                this.pruefen.setBackground(Color.green);
            } else {
                this.pruefen.setBackground(Color.red);
            }
        }
        this.felderAktualisieren();
    }

    private void benutzerEingabeFeldWirdAlsAktuellesFeldGewaehltBefehl(int pWertX, int pWertY) {
        if (pWertX >= 0 && pWertX < 9 && pWertY >= 0 && pWertY < 9) {
            this.steuerung.setzeAktuellesFeld(pWertX, pWertY);
            this.felderAktualisieren();
        }
    }

    private void benutzerEingabeZahlWirdAufFeldAngewendet(int pWert) {
        if (pWert >= 0 && pWert <= 9 && this.steuerung.hatSudokuAktuellesFeld()) {
            this.steuerung.setzteZahlAktuellesFeld(pWert);
            this.felderAktualisieren();
        }
    }

    private void refresh() {
        this.getContentPane().removeAll();
        this.erstelleContentPane();
    }

    private void zeigeSpielGewonnenBefehl() {
        JOptionPane.showMessageDialog(null, "Du hast Gewonnen", "", 1);
    }

    private void erstelleBildschirm() {
        this.setName("Sudoku");
        this.setSize(900, 700);
        this.setDefaultCloseOperation(3);
        this.setLayout(null);
        this.erstelleMenue();
        this.erstelleContentPane();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        this.setVisible(true);
    }

    private void erstelleMenue() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu menuSudokuAuswahl = new JMenu("Sodoku");
        this.menuBar.add(menuSudokuAuswahl);
        final HashMap<JMenuItem, Integer> sudokuUndSudokuNummer = new HashMap<JMenuItem, Integer>();
        for (int sudokuMenuAuswahlNummer = 1; sudokuMenuAuswahlNummer <= this.steuerung.gibAnzahlGespeicherterSudokus(); ++sudokuMenuAuswahlNummer) {
            JMenuItem sudokuMenuItem = new JMenuItem("Sudoku " + sudokuMenuAuswahlNummer);
            sudokuUndSudokuNummer.put(sudokuMenuItem, new Integer(sudokuMenuAuswahlNummer));
            sudokuMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Benutzerschnittstelle.this.ladeSudokuBefehl((Integer)sudokuUndSudokuNummer.get((JMenuItem)e.getSource()));
                }
            });
            menuSudokuAuswahl.add(sudokuMenuItem);
        }
        menuSudokuAuswahl.addSeparator();
        JMenuItem beendenMenuItem = new JMenuItem("Beenden");
        beendenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Benutzerschnittstelle.this.beendenBefehl();
            }
        });
        menuSudokuAuswahl.add(beendenMenuItem);
        JMenu menuHelligkeit = new JMenu("Helligkeit");
        this.menuBar.add(menuHelligkeit);
        JMenuItem menuItemHeller = new JMenuItem("Heller");
        menuHelligkeit.add(menuItemHeller);
        menuItemHeller.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Benutzerschnittstelle.this.hellerBefehl();
            }
        });
        JMenuItem menuItemDunkler = new JMenuItem("Dunkler");
        menuHelligkeit.add(menuItemDunkler);
        menuItemDunkler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Benutzerschnittstelle.this.dunklerBefehl();
            }
        });
        JMenu menuHilfe = new JMenu("Hilfe");
        this.menuBar.add(menuHilfe);
        JMenuItem menuItemEintrag1 = new JMenuItem("Anleitung");
        menuHilfe.add(menuItemEintrag1);
        menuItemEintrag1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Benutzerschnittstelle.this.zeigeAnleitungBefehl();
            }
        });
        JMenuItem menuItemVersion = new JMenuItem("Version");
        menuHilfe.add(menuItemVersion);
        menuItemVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Benutzerschnittstelle.this.zeigeVersionBefehl();
            }
        });
    }

    private void erstelleContentPane() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBorder(new EmptyBorder(6, 6, 6, 6));
        contentPane.setLayout(new BorderLayout(6, 6));
        this.erstelleNorth();
        this.erstelleWest();
        this.erstelleCenter();
    }

    private void erstelleNorth() {
        JPanel panelNorth = new JPanel();
        this.getContentPane().add((Component)panelNorth, "North");
        this.pruefen = new JButton("Pruefen");
        panelNorth.add(this.pruefen);
        this.pruefen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Benutzerschnittstelle.this.pruefenBefehl();
            }
        });
        this.pruefen.setBackground(Color.green);
    }

    private void erstelleWest() {
        JPanel panelWest = new JPanel();
        this.getContentPane().add((Component)panelWest, "West");
        panelWest.setLayout(new FlowLayout());
        JPanel panelBenutzereingaben = new JPanel();
        panelWest.add(panelBenutzereingaben);
        panelBenutzereingaben.setLayout(new GridLayout(0, 2));
        this.benutzereingabe = new HashSet();
        this.hashMapButtonBenutzereingabe = new HashMap();
        for (int i = 0; i < 10; ++i) {
            JButton tmp = new JButton("     " + i + "     ");
            panelBenutzereingaben.add(tmp);
            this.hashMapButtonBenutzereingabe.put(tmp, new Integer(i));
            tmp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Benutzerschnittstelle.this.benutzerEingabeZahlWirdAufFeldAngewendet((Integer)Benutzerschnittstelle.this.hashMapButtonBenutzereingabe.get((JButton)e.getSource()));
                }
            });
            tmp.setBackground(new Color(0, 0, 100));
            tmp.setForeground(new Color(255, 150, 130));
        }
    }

    private void erstelleCenter() {
        JPanel panelCenter = new JPanel();
        this.getContentPane().add((Component)panelCenter, "Center");
        panelCenter.setLayout(null);
        this.erzeugeDasSpielfeld(panelCenter);
    }

    private void erzeugeDasSpielfeld(JPanel pPanelSpielfeld) {
        if (!this.steuerung.istSudokuInitialisiert()) {
            return;
        }
        this.spielfeldMitAllenKnoepfen = null;
        this.spielfeldMitAllenKnoepfen = new JButton[this.steuerung.gibSeitenLaengeVonSudoku()][this.steuerung.gibSeitenLaengeVonSudoku()];
        int xKoordinateSudokuButtons = 0;
        int sudokuBlock3 = 10;
        final HashMap<JButton, Integer> jButtonFeldXKoordinaten = new HashMap<JButton, Integer>();
        final HashMap<JButton, Integer> jButtonFeldYKoordinaten = new HashMap<JButton, Integer>();
        for (int yKoordinateSudokuButtons = 0; yKoordinateSudokuButtons < this.steuerung.gibSeitenLaengeVonSudoku(); ++yKoordinateSudokuButtons) {
            int sudokuBlock3RelativIntY = yKoordinateSudokuButtons / 3;
            for (xKoordinateSudokuButtons = 0; xKoordinateSudokuButtons < this.steuerung.gibSeitenLaengeVonSudoku(); ++xKoordinateSudokuButtons) {
                JButton tmp;
                this.spielfeldMitAllenKnoepfen[yKoordinateSudokuButtons][xKoordinateSudokuButtons] = tmp = new JButton("x=" + xKoordinateSudokuButtons + 1 + "   y=" + yKoordinateSudokuButtons + 1);
                int sudokuBlock3RelativIntX = xKoordinateSudokuButtons / 3;
                tmp.setBounds(sudokuBlock3 * sudokuBlock3RelativIntX + (xKoordinateSudokuButtons + 1) * 52, sudokuBlock3 * sudokuBlock3RelativIntY + (yKoordinateSudokuButtons + 1) * 52, 50, 50);
                if (this.steuerung.istFeldVeraenderbar(xKoordinateSudokuButtons, yKoordinateSudokuButtons)) {
                    tmp.setForeground(FELD_VERAENDERBAR);
                } else {
                    tmp.setForeground(FELD_NICHT_VERAENDERBAR);
                }
                pPanelSpielfeld.add(tmp);
                jButtonFeldXKoordinaten.put(tmp, new Integer(xKoordinateSudokuButtons));
                jButtonFeldYKoordinaten.put(tmp, new Integer(yKoordinateSudokuButtons));
                tmp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Benutzerschnittstelle.this.benutzerEingabeFeldWirdAlsAktuellesFeldGewaehltBefehl((Integer)jButtonFeldXKoordinaten.get((JButton)e.getSource()), (Integer)jButtonFeldYKoordinaten.get((JButton)e.getSource()));
                    }
                });
            }
        }
        this.hellerBefehl();
        this.felderAktualisieren();
    }

    private void felderAktualisieren() {
        if (this.steuerung.istSudokuInitialisiert()) {
            int xKoordinateSudokuButtons = 0;
            for (int yKoordinateSudokuButtons = 0; yKoordinateSudokuButtons < this.steuerung.gibSeitenLaengeVonSudoku(); ++yKoordinateSudokuButtons) {
                for (xKoordinateSudokuButtons = 0; xKoordinateSudokuButtons < this.steuerung.gibSeitenLaengeVonSudoku(); ++xKoordinateSudokuButtons) {
                    JButton tmp = null;
                    tmp = this.spielfeldMitAllenKnoepfen[yKoordinateSudokuButtons][xKoordinateSudokuButtons];
                    if (this.steuerung.getZahlFeld(xKoordinateSudokuButtons, yKoordinateSudokuButtons) == 0) {
                        tmp.setText("");
                    } else if (this.steuerung.getZahlFeld(xKoordinateSudokuButtons, yKoordinateSudokuButtons) >= 1 && this.steuerung.getZahlFeld(xKoordinateSudokuButtons, yKoordinateSudokuButtons) <= 9) {
                        tmp.setText("" + this.steuerung.getZahlFeld(xKoordinateSudokuButtons, yKoordinateSudokuButtons));
                    } else {
                        System.out.println("Fehler buttonsRichtigeZahlenGeben(), else");
                    }
                    tmp.setBackground(this.aktuelleHintergrundfarbe);
                    if (!this.steuerung.istAktuellesFeld(xKoordinateSudokuButtons, yKoordinateSudokuButtons)) continue;
                    tmp.setBackground(FELD_AKTUELLES_FELD);
                }
            }
            if (this.steuerung.spielIstGewonnen()) {
                this.zeigeSpielGewonnenBefehl();
            }
        }
    }
}

