/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JFrame;

public class Benutzerschnittstelle
extends JFrame {
    private Steuerung steuerung;
    private Sudoku sudoku;
    private HashMap<JButton, Feld> hashMapButtonFeld;
    private HashMap<JButton, Integer> hashMapButtonBenutzereingabe;
    private static final Color FELD_VERAENDERBAR = Color.green;
    private static final Color FELD_NICHT_VERAENDERBAR = Color.black;
    private JButton beenden;
    private JButton pruefen;
    private JButton formation1;
    private JButton[][] feld1;
    private HashSet<JButton> benutzereingabe;
    private JButton aktuellesFeld;
    private final ActionListener listenerBeenden = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    };
    private final ActionListener listenerButtonsFormation1 = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Benutzerschnittstelle.this.steuerung.formation1();
            Benutzerschnittstelle.this.erzeugeDasSpielfeld();
            Benutzerschnittstelle.this.felderAktualisieren();
        }
    };
    private final ActionListener listenerButtonsPruefen = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Benutzerschnittstelle.this.sudoku.besitztFeld()) {
                boolean tmp = Benutzerschnittstelle.this.steuerung.testeObSudokuKorrektIst();
                if (tmp) {
                    Benutzerschnittstelle.this.pruefen.setBackground(Color.green);
                } else {
                    Benutzerschnittstelle.this.pruefen.setBackground(Color.red);
                }
            }
        }
    };
    private final ActionListener listenerButtonsSpielfeld = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Benutzerschnittstelle.this.sudoku.besitztFeld()) {
                Benutzerschnittstelle.this.aktuellesFeld = (JButton)e.getSource();
                Benutzerschnittstelle.this.felderAktualisieren();
            }
        }
    };
    private final ActionListener listenerButtonsBenutzereingabe = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Benutzerschnittstelle.this.sudoku.besitztFeld()) {
                JButton tmp = (JButton)e.getSource();
                int wert = (Integer)Benutzerschnittstelle.this.hashMapButtonBenutzereingabe.get(tmp);
                ((Feld)Benutzerschnittstelle.this.hashMapButtonFeld.get(Benutzerschnittstelle.this.aktuellesFeld)).setzeZahl(wert);
                Benutzerschnittstelle.this.felderAktualisieren();
            }
        }
    };

    public Benutzerschnittstelle(Steuerung pSteuerung, Sudoku pSudoku) {
        this.steuerung = pSteuerung;
        this.sudoku = pSudoku;
        this.erstelleBildschirm();
    }

    private void erstelleBildschirm() {
        this.setName("Game of Live");
        this.setSize(900, 700);
        this.setDefaultCloseOperation(3);
        this.setLayout(null);
        this.beenden = new JButton("Beenden");
        this.beenden.setBounds(20, 50, 120, 20);
        this.add(this.beenden);
        this.beenden.addActionListener(this.listenerBeenden);
        this.formation1 = new JButton("Formation1");
        this.formation1.setBounds(20, 230, 120, 20);
        this.add(this.formation1);
        this.formation1.addActionListener(this.listenerButtonsFormation1);
        this.pruefen = new JButton("Pruefen");
        this.pruefen.setBounds(20, 90, 120, 20);
        this.add(this.pruefen);
        this.pruefen.addActionListener(this.listenerButtonsPruefen);
        this.eingabeFeldInitialisieren();
        this.setVisible(true);
    }

    private void felderAktualisieren() {
        int maximalY = this.sudoku.gibSeitenLaenge();
        int maximalX = this.sudoku.gibSeitenLaenge();
        int positionX = 0;
        for (int positionY = 0; positionY < maximalY; ++positionY) {
            for (positionX = 0; positionX < maximalX; ++positionX) {
                JButton tmp = null;
                tmp = this.feld1[positionY][positionX];
                Feld felder = this.hashMapButtonFeld.get(tmp);
                if (felder.getZahl() == 0) {
                    tmp.setText("");
                } else if (felder.getZahl() >= 1 && felder.getZahl() <= 9) {
                    tmp.setText("" + felder.getZahl());
                } else {
                    System.out.println("Fehler buttonsRichtigeZahlenGeben(), else");
                }
                tmp.setBackground(Color.white);
                if (this.aktuellesFeld == null) continue;
                this.aktuellesFeld.setBackground(Color.yellow);
            }
        }
    }

    private void erzeugeDasSpielfeld() {
        this.feld1 = null;
        int maximalY = this.sudoku.gibSeitenLaenge();
        int maximalX = this.sudoku.gibSeitenLaenge();
        this.feld1 = new JButton[maximalY][maximalX];
        int positionX = 0;
        this.hashMapButtonFeld = new HashMap();
        int sudokuBlock3 = 10;
        for (int positionY = 0; positionY < maximalY; ++positionY) {
            int sudokuBlock3RelativIntY = positionY / 3;
            for (positionX = 0; positionX < maximalX; ++positionX) {
                JButton tmp;
                this.feld1[positionY][positionX] = tmp = new JButton("x=" + positionX + 1 + "   y=" + positionY + 1);
                int sudokuBlock3RelativIntX = positionX / 3;
                tmp.setBounds(250 + sudokuBlock3 * sudokuBlock3RelativIntX + (positionX + 1) * 52, 20 + sudokuBlock3 * sudokuBlock3RelativIntY + (positionY + 1) * 52, 50, 50);
                this.hashMapButtonFeld.put(tmp, this.sudoku.gibFeld(positionX, positionY));
                if (this.sudoku.veraenderbar(positionX, positionY)) {
                    tmp.setForeground(FELD_VERAENDERBAR);
                } else if (!this.sudoku.veraenderbar(positionX, positionY)) {
                    tmp.setForeground(FELD_NICHT_VERAENDERBAR);
                }
                this.add(tmp);
                tmp.addActionListener(this.listenerButtonsSpielfeld);
            }
        }
    }

    public void eingabeFeldInitialisieren() {
        JButton tmp;
        int y;
        int x;
        int i;
        this.benutzereingabe = new HashSet();
        this.hashMapButtonBenutzereingabe = new HashMap();
        for (i = 0; i < 5; ++i) {
            x = 60;
            y = 60;
            tmp = new JButton("" + i);
            this.benutzereingabe.add(tmp);
            tmp.setBounds(20 + x, 300 + y * i, 50, 50);
            this.add(tmp);
            tmp.addActionListener(this.listenerButtonsBenutzereingabe);
            this.hashMapButtonBenutzereingabe.put(tmp, new Integer(i));
        }
        for (i = 5; i < 10; ++i) {
            x = 60;
            y = 60;
            tmp = new JButton("" + i);
            this.benutzereingabe.add(tmp);
            tmp.setBounds(20 + x + 60, 300 + y * (i - 5), 50, 50);
            this.add(tmp);
            tmp.addActionListener(this.listenerButtonsBenutzereingabe);
            this.hashMapButtonBenutzereingabe.put(tmp, new Integer(i));
        }
    }
}

